/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.inventory;

import dev.terminalmc.clientsort.config.Config;
import dev.terminalmc.clientsort.inventory.CreativeContainerScreenHelper;
import dev.terminalmc.clientsort.inventory.sort.Scope;
import dev.terminalmc.clientsort.network.InteractionManager;
import dev.terminalmc.clientsort.util.inject.ISlot;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_485;

public class ContainerScreenHelper<T extends class_465<?>> {
    protected final T screen;
    protected final InteractionManager.ClickEventFactory clickEventFactory;

    protected ContainerScreenHelper(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        this.screen = screen;
        this.clickEventFactory = clickEventFactory;
    }

    public static <T extends class_465<?>> ContainerScreenHelper<T> of(T screen, InteractionManager.ClickEventFactory clickEventFactory) {
        if (screen instanceof class_481) {
            return new CreativeContainerScreenHelper<class_481>((class_481)screen, clickEventFactory);
        }
        return new ContainerScreenHelper<T>(screen, clickEventFactory);
    }

    public InteractionManager.InteractionEvent createClickEvent(class_1735 slot, int action, class_1713 actionType, boolean playSound) {
        return this.clickEventFactory.create(slot, action, actionType, playSound);
    }

    public boolean isHotbarSlot(class_1735 slot) {
        return ((ISlot)slot).clientSort$getIndexInInv() < 9;
    }

    public boolean isExtraSlot(class_1735 slot) {
        return ((ISlot)slot).clientSort$getIndexInInv() >= 40;
    }

    public Scope getScope(class_1735 slot) {
        if (!slot.method_7680(class_1799.field_8037)) {
            return Scope.INVALID;
        }
        if (this.screen instanceof class_485) {
            if (slot.field_7871 instanceof class_1661) {
                boolean mergeWithHotbar = false;
                if (this.isExtraSlot(slot)) {
                    switch (Config.options().extraSlotScope) {
                        case HOTBAR: {
                            mergeWithHotbar = true;
                            break;
                        }
                        case EXTRA: {
                            return Scope.PLAYER_INV_EXTRA;
                        }
                        case NONE: {
                            return Scope.INVALID;
                        }
                    }
                }
                if (mergeWithHotbar || this.isHotbarSlot(slot)) {
                    switch (Config.options().hotbarScope) {
                        case HOTBAR: {
                            return Scope.PLAYER_INV_HOTBAR;
                        }
                        case NONE: {
                            return Scope.INVALID;
                        }
                    }
                }
                return Scope.PLAYER_INV;
            }
            return Scope.PLAYER_OTHER;
        }
        if (slot.field_7871 instanceof class_1661) {
            if (this.isHotbarSlot(slot)) {
                switch (Config.options().hotbarScope) {
                    case HOTBAR: {
                        return Scope.PLAYER_INV_HOTBAR;
                    }
                    case NONE: {
                        return Scope.INVALID;
                    }
                }
            }
            return Scope.PLAYER_INV;
        }
        return Scope.CONTAINER_INV;
    }

    public void translateSlotMapping(int[] slotMapping) {
    }
}

